'http://www.facebook.com/GtaIVScripting
'https://www.youtube.com/user/GTAScripting

'Javelin script by JulioNIB

Imports System
Imports GTA
Imports System.Windows.Forms
Imports System.Drawing
Imports System.Collections.Generic
imports system.io
Imports System.text

Public Class RocketLock
    Inherits Script
	
	private width_Coef, height_Coef as double
	private myWidth, myHeight as double
	private rocket as gta.object = nothing
	private bLaunched as boolean
	private FirstMove, timeWait as double
	private bGoingUp, bGoingUp2, bGoingDown as boolean
	private fixRotation as vector3
	private fixDirection as vector3
	private fixDirectionAux as vector3
	private initialPosition as vector3
	private PTFXSmoke, PTFXExp as int32
	private LaunchSID, MoveSID, BeepSID as int32
	private vehList as vehicle()
	private targetVeh as vehicle = nothing
	private tmpTargetVeh as vehicle = nothing
	private targetVehOffsetH as double
	private targetGround as vector3 = vector3.zero
	private tmpTargetGround as vector3 = vector3.zero
	'private cpTarget as checkpoint = new checkpoint
	private midPos as vector3
	private midPos2 as vector3
	private camRocket as camera = new camera
	private camAim as camera = new camera
	private timeLookingForVeh as double = 0
	private timeLocked as double = 0
	private timeLockingBeep as double = 0
	private texHUD, texCLU, texRReady, texLock, texDir, texTop, texLaunched, texDAY, texWFOV, texNFOV, texNV as texture
	private myRpgObj as gta.object = nothing
	private bWasAlive as boolean = false
	private fakeTrainModel as model = nothing
	private bDerailTrains as boolean = false
	private timeWaitAim as double
	private bJavelin as boolean = true
	private bNormalMode as boolean = false
	private JavelinPower, StingerPower, Power as double	
	private AutoEquipAmount as int16 = 0
	private MaxAttackDistance as double
	private zOffSetPTFX as double = 0
	private rocketModel as string
	private FOV as int16 = 50
	private minFOV as int16 = 20
	private timeWaitLoad as double = 500
	private zoomType as int16 = 0
	private WFOV, NFOV as double
	private timeReloadNV as double = 0
	private bResetNV as boolean = false
	private bNVOn as boolean = false
	private timeCheckRocket as double = 500
	private bAttackDir as boolean = false
	private timeCheckSoundBug as double = 500
	private timeNVTick as double = 0
	private wantedLevel as int16 = 1
	private bLocking as boolean = false
	private bAutoLocking as boolean
	
	private soundLocked as string = ""
	private soundLocking as string = ""
	private sndJLaunch As New System.Media.SoundPlayer()
	private sndLocking As New System.Media.SoundPlayer()
	private sndLocked As New System.Media.SoundPlayer()
	private sndSwitch As New System.Media.SoundPlayer()
	
	private hkShoot, hkDefaultShoot, hkRocketCam, hkAimKey, hkSteadyAim, hkZoomIN, hkZoomOUT, hkSwitchZoom, hkSwitchAttackMode, hkNightVision as keys
	
	private class TFakeTrain
		public train as vehicle = nothing
		public trainObj as gta.object = nothing
		public rot as vector3
		public speed as double
		public dist as double
		public bSet as boolean = true
		public bMove as boolean = false
		public pos as vector3
	end class
	
	private tmpTFakeTrain as TFakeTrain
	private TFakeTrainList as new list(of TFakeTrain)
	
	private class lights
		public l as light = new light
		public offSet as vector3
		
		public sub new
			l.color = color.green
			l.intensity = 1000
		end sub
	end class
	private tmpLight as lights
	
	private class TNVLight
		public l as light = new light
		public l2 as light = new light
		public lightList as new list(of lights)
		public v as vehicle = nothing
		public p as ped = nothing
		public VOff as double = 0
		public bLarge as boolean
	end class
	
	private tmpTNVLight as TNVLight
	private TNVLightVehList as new list(of TNVLight)
	private TNVLightPedList as new list(of TNVLight)
	
    Public Sub New()
        Me.interval = 10
		
		'world.createvehicle("bus", game.currentcamera.position - game.currentcamera.direction * 5)
	end sub
	
	private sub loadAux
		Game.Console.Print("Rocket lock Script Mod by JulioNIB v1.1")
		
		myWidth = 1680
		myHeight = 1050
		width_Coef = game.resolution.width / myWidth
		height_Coef = game.resolution.height / myHeight

		MoveSID = native.function.call(of int32)("get_sound_id")
		LaunchSID = native.function.call(of int32)("get_sound_id")
		BeepSID = native.function.call(of int32)("get_sound_id")
		
		texHUD = new texture(file.readallbytes(".\scripts\RocketLockFiles\HUDb.png"))
		texCLU = new texture(file.readallbytes(".\scripts\RocketLockFiles\CLU.png"))
		texRReady = new texture(file.readallbytes(".\scripts\RocketLockFiles\RReady.png"))
		texLock = new texture(file.readallbytes(".\scripts\RocketLockFiles\Lock.png"))
		texDir = new texture(file.readallbytes(".\scripts\RocketLockFiles\Dir.png"))
		texTop = new texture(file.readallbytes(".\scripts\RocketLockFiles\Top.png"))
		texLaunched = new texture(file.readallbytes(".\scripts\RocketLockFiles\Launched.png"))
		texDAY = new texture(file.readallbytes(".\scripts\RocketLockFiles\DAY.png"))
		texWFOV = new texture(file.readallbytes(".\scripts\RocketLockFiles\WFOV.png"))
		texNFOV = new texture(file.readallbytes(".\scripts\RocketLockFiles\NFOV.png"))
		texNV = new texture(file.readallbytes(".\scripts\RocketLockFiles\NV.png"))
		
		if Settings.GetValueKey("hkShoot", "general", -1) = -1 then Settings.SetValue("hkShoot", "general", keys.space)
		if Settings.GetValueKey("hkDefaultShoot", "general", -1) = -1 then Settings.SetValue("hkDefaultShoot", "general", keys.lbutton)
		if Settings.GetValueKey("hkRocketCam", "general", -1) = -1 then Settings.SetValue("hkRocketCam", "general", keys.tab)
		if Settings.GetValueKey("hkAimKey", "general", -1) = -1 then Settings.SetValue("hkAimKey", "general", keys.rbutton)
		if Settings.GetValueKey("hkZoomIN", "general", -1) = -1 then Settings.SetValue("hkZoomIN", "general", keys.E)
		if Settings.GetValueKey("hkZoomOUT", "general", -1) = -1 then Settings.SetValue("hkZoomOUT", "general", keys.Q)
		if Settings.GetValueKey("hkSwitchZoom", "general", -1) = -1 then Settings.SetValue("hkSwitchZoom", "general", keys.capslock)
		if Settings.GetValueKey("hkSwitchAttackMode", "general", -1) = -1 then Settings.SetValue("hkSwitchAttackMode", "general", keys.mbutton)
		if Settings.GetValueKey("hkNightVision", "general", -1) = -1 then Settings.SetValue("hkNightVision", "general", keys.N)
		if Settings.GetValueKey("hkSteadyAim", "general", -1) = -1 then Settings.SetValue("hkSteadyAim", "general", keys.shiftkey)
		if Settings.GetValueString("bDerailTrains", "general", "") = "" then Settings.SetValue("bDerailTrains", "general", "0")
		if Settings.GetValueString("fakeTrainModel", "general", "") = "" then Settings.SetValue("fakeTrainModel", "general", "subway_lo")
		if Settings.GetValueString("bJavelin", "general", "") = "" then Settings.SetValue("bJavelin", "general", "1")
		if Settings.GetValueString("JavelinPower", "general", "") = "" then Settings.SetValue("JavelinPower", "general", "1.0")
		if Settings.GetValueString("StingerPower", "general", "") = "" then Settings.SetValue("StingerPower", "general", "0.5")
		if Settings.GetValueString("AutoEquipAmount", "general", "") = "" then Settings.SetValue("AutoEquipAmount", "general", "0")
		if Settings.GetValueString("MaxAttackDistance", "general", "") = "" then Settings.SetValue("MaxAttackDistance", "general", "200")
		if Settings.GetValueString("rocketModel", "general", "") = "" then Settings.SetValue("rocketModel", "general", "cj_rpg_rocket")
		if Settings.GetValueString("minFOV", "general", "") = "" then Settings.SetValue("minFOV", "general", "5")
		if Settings.GetValueString("WFOV", "general", "") = "" then Settings.SetValue("WFOV", "general", "25")
		if Settings.GetValueString("NFOV", "general", "") = "" then Settings.SetValue("NFOV", "general", "10")
		if Settings.GetValueString("bAutoLocking", "general", "") = "" then Settings.SetValue("bAutoLocking", "general", "1")
		if Settings.GetValueString("soundLocking", "general", "") = "" then Settings.SetValue("soundLocking", "general", "")
		if Settings.GetValueString("soundLocked", "general", "") = "" then Settings.SetValue("soundLocked", "general", "")
		
		Settings.save
		
		hkShoot = Settings.GetValueKey("hkShoot", "general", -1)
		hkDefaultShoot = Settings.GetValueKey("hkDefaultShoot", "general", -1)
		hkRocketCam = Settings.GetValueKey("hkRocketCam", "general", -1)
		hkAimKey = Settings.GetValueKey("hkAimKey", "general", -1)
		hkZoomIN = Settings.GetValueKey("hkZoomIN", "general", -1)
		hkZoomOUT = Settings.GetValueKey("hkZoomOUT", "general", -1)
		hkSwitchZoom = Settings.GetValueKey("hkSwitchZoom", "general", -1)
		hkSwitchAttackMode = Settings.GetValueKey("hkSwitchAttackMode", "general", -1)
		hkNightVision = Settings.GetValueKey("hkNightVision", "general", -1)
		hkSteadyAim = Settings.GetValueKey("hkSteadyAim", "general", -1)
		
		bDerailTrains = Settings.GetValueKey("bDerailTrains", "general", -1) = 1
		bJavelin = Settings.GetValueKey("bJavelin", "general", -1) = 1
		JavelinPower = Settings.GetValueFloat("JavelinPower", "general", 1)
		StingerPower = Settings.GetValueFloat("StingerPower", "general", 1)
		AutoEquipAmount = Settings.GetValueKey("AutoEquipAmount", "general", -1)
		MaxAttackDistance = Settings.GetValueKey("MaxAttackDistance", "general", 200)
		rocketModel = Settings.GetValueString("rocketModel", "general", "cj_rpg_rocket")
		minFOV = Settings.GetValueFloat("rocketModel", "general", 5)
		WFOV = Settings.GetValueFloat("WFOV", "general", 5)
		NFOV = Settings.GetValueFloat("NFOV", "general", 5)
		bAutoLocking = Settings.GetValueFloat("bAutoLocking", "general", 1) = 1
		soundLocking = Settings.GetValueString("soundLocking", "general", "")
		soundLocked = Settings.GetValueString("soundLocked", "general", "")
		
		if Settings.GetValueString("fakeTrainModel", "general", "") <> "none" then
			fakeTrainModel = new model(Settings.GetValueString("fakeTrainModel", "general", ""))
		else
			fakeTrainModel = nothing
		end if
		
		if bJavelin then
			Power = JavelinPower
		else
			Power = StingerPower
		end if
		
		rocket = world.createobject(rocketModel, player.character.position + vector3.worldup * 100)
		wait(50)		
		if not exists(rocket) then rocket = world.createobject(rocketModel, player.character.position + vector3.worldup * 100)
		
		zOffSetPTFX = rocket.model.getdimensions.z * -1
		
		rocket.visible = false
		native.function.call("ATTACH_OBJECT_TO_PED", rocket, player.character, bone.righthand, 0, 0, 0, 0, 0, 0)
		
		if AutoEquipAmount > 0 then player.character.weapons.RocketLauncher.ammo = AutoEquipAmount
		
		sndJLaunch.soundlocation = ".\scripts\RocketLockFiles\jlaunch.wav"
		sndJLaunch.load
		
		if soundLocking <> "" then
			sndLocking.soundlocation = ".\scripts\RocketLockFiles\" & soundLocking
			sndLocking.load
		end if
		if soundLocked <> "" then
			sndLocked.soundlocation = ".\scripts\RocketLockFiles\" & soundLocked
			sndLocked.load
		end if
		
		sndSwitch.soundlocation = ".\scripts\RocketLockFiles\Switch.wav"
		sndSwitch.load
			
		if bJavelin then
			camAim.fov = WFOV
		else
			camAim.fov = 50
		end if
	end sub
	
	private sub msg(sMsg as string, time as int32)
		Native.Function.Call("PRINT_STRING_WITH_LITERAL_STRING_NOW", "STRING", sMsg, time, 1)
	end sub
	
    Private Sub keyDown(ByVal sender As Object, ByVal e As GTA.KeyEventArgs) Handles MyBase.KeyDown		
		if bNormalMode then exit sub
		
		if (e.key = hkNightVision) andalso bJavelin andalso camAim.isactive then
			bNVOn = not bNVOn
			
			timeReloadNV = 0
			
			sndSwitch.play
		end if
		
		if (e.key = hkAimKey) andalso not bLaunched then
			vehList = world.getvehicles(player.character.getboneposition(bone.head) + game.currentcamera.direction * 100, 200.0)
			targetVeh = nothing
			tmpTargetVeh = nothing
			targetGround = vector3.zero
			tmpTargetGround = vector3.zero
			
			timeReloadNV = 0
		end if
		
		if (e.key = hkSwitchZoom) andalso bJavelin andalso camAim.isactive then
			zoomType += 1
			
			if zoomType > 2 then zoomType = 0
			
			switchFOV
			
			sndSwitch.play
		end if
		
		if (e.key = hkSwitchAttackMode) andalso bJavelin andalso camAim.isactive then
			bAttackDir = not bAttackDir
			
			sndSwitch.play
		end if
		
		if ((e.key = hkShoot) orelse (e.key = hkDefaultShoot)) andalso (player.character.weapons.current = weapon.Heavy_RocketLauncher) andalso not bLaunched then
			if not bAutoLocking andalso not bLocking then
				bLocking = true
				exit sub
			end if
			
			if (timeLocked < 300) then exit sub
			
			if camRocket.isactive then camRocket.deactivate	
			
			native.function.call("set_char_all_anims_speed", player.character, 1.0)
			
			native.function.call("SET_OBJECT_RECORDS_COLLISIONS", rocket, false)
			
			rocket.detach
			rocket.visible = true
			fixRotation = game.currentcamera.rotation
			fixDirection = game.currentcamera.direction
			fixDirectionAux = player.character.direction
			initialPosition = player.character.position
			bLaunched = true
			timeCheckSoundBug = 500
			FirstMove = 120
			bGoingUp = true
			bGoingUp2 = true
			bGoingDown = true
			timeWait = 200
			
			if not bJavelin then
				native.function.call("stop_sound", LaunchSID)
				native.function.call("PLAY_SOUND_FROM_object", LaunchSID, "ROCKET_GRENADE_LAUNCH", rocket)
				
				native.function.call("stop_ptfx", PTFXSmoke)				
				PTFXSmoke = native.function.call(of int32)("START_PTFX_ON_OBJ", "weap_rocket_player", rocket, 0, 0, zOffSetPTFX, 0, 0, 0, 2.0)
				
				native.function.call("stop_sound", MoveSID)
				native.function.call("PLAY_SOUND_FROM_object", MoveSID, "GENERAL_WEAPONS_ROCKET_LOOP", rocket)
			else
				sndJLaunch.play
			end if
			
			if not bJavelin then
				timeWait = 25
				rocket.applyforce(fixDirection * 4 + vector3.worldup * 2)
			else
				if bAttackDir then
					rocket.applyforce(fixDirection * 10 + vector3.worldup * 4)
				else
					rocket.applyforce(fixDirection * 10 + vector3.worldup * 3)
				end if
			end if
			rocket.rotation = fixRotation

			dim bWanted as boolean = false
			
			for each p as ped in world.getpeds(player.character.position, 20.0)
				if exists(p) andalso (p <> player.character) then
					if (p.pedtype <> pedtype.cop) then
						p.task.FleeFromChar(player.character, false, 15000)
					else
						bWanted = true
					end if
				end if
			next
			
			if bWanted then
				player.character.WantedByPolice = true
				native.function.call("ALTER_WANTED_LEVEL_NO_DROP", player, 1)
				native.function.call("APPLY_WANTED_LEVEL_CHANGE_NOW", player, 1)
			end if
			
			calcMidPos
		end if
    End Sub	
	Private Sub keyUp(ByVal sender As Object, ByVal e As GTA.KeyEventArgs) Handles MyBase.KeyUp
	end sub
	
	private function calcMidPos(optional bPos2 as boolean = false)
		dim tmpPos as vector3
		dim tmpVel as vector3 = vector3.zero
		
		if exists(targetVeh) then
			tmpPos = targetVeh.position
			tmpVel = targetVeh.velocity
		elseif targetGround <> vector3.zero then
			tmpPos = targetGround
		else
			return false
		end if
		
		if not bJavelin then
			midPos = initialPosition + fixDirectionAux * (tmpPos.distanceto(initialPosition) * 0.3)
			midPos.z += 1
		else
			if not bAttackDir then
				if not bPos2 then
					midPos = rocket.position + fixDirectionAux * ((tmpPos + tmpVel).distanceto(rocket.position) * 0.2)
					
					midPos.z += midPos.z + (fixDirectionAux * (tmpPos + tmpVel).distanceto(initialPosition) * 0.3).z
					
					if midPos.z - initialPosition.z < 30 then midPos.z = initialPosition.z + 30
					
					if midPos.z < tmpPos.z then midPos.z = tmpPos.z + 30				
				else
					midPos2 = rocket.position + fixDirectionAux * ((tmpPos + tmpVel).distanceto(rocket.position) * 0.3)
				end if
			else
				midPos = rocket.position + fixDirectionAux * 15
				midPos.z = initialPosition.z + 10
				
				midPos2 = midPos
			end if
		end if
		
		return true
	end function
	
	Private Sub general_tick(ByVal sender As Object, ByVal e As EventArgs) Handles MyBase.Tick
		if (timeWaitLoad > 0) then
			timeWaitLoad -= intervalFix
			
			exit sub
		elseif timeWaitLoad <> -10000 then
			timeWaitLoad = -10000
			
			loadAux
		end if
	
		if bNormalMode then exit sub
		
		if not bWasAlive andalso player.character.isalive then
			resetRocket
			
			for each t as TFakeTrain in TFakeTrainList
				if exists(t.trainObj) then				
					t.trainObj.delete
				end if
			next
			
			TFakeTrainList.clear
		end if
		
		if timeCheckSoundBug <= 0 then
			timeCheckSoundBug = 500
			
			if not bLaunched then native.function.call("stop_sound", MoveSID)
		else
			timeCheckSoundBug -= Me.interval
		end if
		
		bWasAlive = player.character.isalive
		
		if (player.character.weapons.current = weapon.Heavy_RocketLauncher) andalso player.character.isshooting then
			for each o as gta.object in world.getallobjects("cj_rpg_rocket")
				if exists(o) andalso (o <> rocket) then o.delete
			next
			
			player.character.weapons.RocketLauncher.AmmoInClip = 1
		end if
		
		if bLaunched then
			if native.function.call(of boolean)("HAS_OBJECT_COLLIDED_WITH_ANYTHING", rocket) orelse _
			   (rocket.position.distanceto(player.character.position) > 200) then
			    if game.iskeypressed(hkRocketCam) then
					startSlowMoFX
				end if
				
				bLaunched = false
				
				dim bWanted as boolean = false
				
				for each p as ped in world.getpeds(rocket.position, 30.0 * Power)
					if exists(p) then
						if not p.isSittingInVehicle then
							p.preventragdoll = false
							p.euphoria.bodybalance.start(5000)
							p.applyforce(vector3.normalize(p.position - rocket.position) * (32 * Power - p.position.distanceto(rocket.position)))
							
							p.health -= (100 - (p.position.distanceto(rocket.position) * 3)) * Power
						end if
						
						if p.pedtype = pedtype.cop then bWanted = true
					end if
				next
				
				for each v as vehicle in world.getvehicles(rocket.position, 30.0 * Power)					
					if exists(v) then						
						if not v.model.istrain then
							v.applyforce(vector3.normalize(v.position - rocket.position) * ((30 * Power - v.position.distanceto(rocket.position)) / 2))
							
							if v.position.distanceto(rocket.position) <= 20 * Power then v.petroltankhealth = -1
						elseif bDerailTrains andalso exists(fakeTrainModel) then							
							tmpTFakeTrain = new TFakeTrain
							tmpTFakeTrain.rot = v.rotation
							tmpTFakeTrain.speed = v.speed
							tmpTFakeTrain.dist = v.position.distanceto(rocket.position)
							tmpTFakeTrain.pos = v.position
							v.delete

							TFakeTrainList.add(tmpTFakeTrain)
							
							bWanted = true
						end if
					end if
				next
				
				if bWanted then					
					wantedLevel += 1
					player.character.WantedByPolice = true
					native.function.call("ALTER_WANTED_LEVEL_NO_DROP", player, wantedLevel)
					native.function.call("APPLY_WANTED_LEVEL_CHANGE_NOW", player, wantedLevel)
				end if
				
				for each t as TFakeTrain in TFakeTrainList
					if exists(t.trainObj) andalso t.bMove andalso (t.trainObj.position.distanceto(rocket.position) < 30 * Power) then				
						t.trainObj.applyforce(vector3.normalize(t.trainObj.position - rocket.position) * ((30 * Power - t.trainObj.position.distanceto(rocket.position)) / 2))
					end if
				next
				
				camRocket.deactivate
				native.function.call("stop_ptfx", PTFXExp)
				
				if game.iskeypressed(hkRocketCam) then
					native.function.call("stop_ptfx", PTFXSmoke)		
					native.function.call("stop_sound", MoveSID)
					rocket.visible = false
					
					if not exists(targetVeh) then
						PTFXExp = native.function.call(of int32)("start_PTFX", "exp_ship_destroy", rocket.position.x, rocket.position.y, rocket.position.z, 0, 0, 0, 0.5)
					else
						PTFXExp = native.function.call(of int32)("start_PTFX_on_veh", "exp_ship_destroy", targetVeh, rocket.position.x, rocket.position.y, rocket.position.z, 0, 0, 0, 0.5)
					end if
					
					dim tmpPosLook as vector3 = startSlowMoFX
					
					if exists(targetVeh) then camRocket.lookat(targetVeh) else camRocket.lookat(tmpPosLook)
					
					dim timeWaitExp as double = 300
					
					dim timeScaleAux as double = 0.01
					
					while game.iskeypressed(hkRocketCam)
						game.timescale = timeScaleAux
						
						if timeScaleAux < 0.2 then timeScaleAux += 0.01
						
						wait(intervalFix)
						
						camRocket.position -= (camRocket.direction * 0.5 - vector3.worldup * 0.2) * 0.1
						
						if timeWaitExp > 0 then
							timeWaitExp -= intervalFix
						
							if timeWaitExp <= 0 then
								if exists(targetVeh) then 
									world.addexplosion(rocket.position, ExplosionType.Rocket, 100 * Power, true, true, 1.0)
								else
									world.addexplosion(tmpPosLook, ExplosionType.Rocket, 100 * Power, true, true, 1.0)
								end if
								
								PTFXExp = native.function.call(of int32)("start_PTFX", "exp_ship_destroy", rocket.position.x, rocket.position.y, rocket.position.z, 0, 0, 0, 0.1)
							end if
						end if
					end while
					
					game.timescale = 1.0
					camRocket.deactivate
				else
					world.addexplosion(rocket.position, ExplosionType.Rocket, 100 * Power, true, true, 1.0)
					
					PTFXExp = native.function.call(of int32)("start_PTFX", "exp_ship_destroy", rocket.position.x, rocket.position.y, rocket.position.z, 0, 0, 0, 1.0 * Power)
				end if
				
				resetRocket
			else
				dim tmpDir as vector3
				dim tmpPos as vector3
				
				if bJavelin then
					if FirstMove > 0 then
						rocket.applyforce(vector3.worldup * 0.2)
						
						FirstMove -= intervalFix
						
						camRocket.position = rocket.getoffsetposition(vector3.relativeback * 1.5)
					
						if FirstMove <= 0 then
							native.function.call("stop_ptfx", PTFXSmoke)
							PTFXSmoke = native.function.call(of int32)("START_PTFX_ON_OBJ", "weap_rocket_player", rocket, 0, 0, zOffSetPTFX, 0, 0, 0, 2.0)

							native.function.call("PLAY_SOUND_FROM_object", MoveSID, "GENERAL_WEAPONS_ROCKET_LOOP", rocket)
							
							native.function.call("SET_OBJECT_RECORDS_COLLISIONS", rocket, true)
						end if
					elseif bGoingUp then
						camRocket.position = rocket.position + vector3.worldup * 1.5
						
						if rocket.position.distanceto(midPos) < 5 then
							bGoingUp = false
							calcMidPos(true)
						else
							tmpDir = vector3.normalize(midPos - rocket.position)
							rocket.applyforce(tmpDir * 3)
							midPos += fixDirectionAux * 0.1
							tmpPos = midPos
						end if
					elseif bGoingUp2 then
						camRocket.position = rocket.position + vector3.worldup * 1.5
						
						if rocket.position.distanceto(midPos2) < 10 then
							bGoingUp2 = false
						else
							tmpDir = vector3.normalize(midPos2 - rocket.position)
							rocket.applyforce(tmpDir * 3)
							midPos2 += fixDirectionAux * 0.1
						end if
						
						tmpPos = midPos2
					elseif bGoingDown then
						camRocket.position = rocket.position + vector3.worldup * 1.5
						
						if exists(targetVeh) then
							tmpDir = vector3.normalize(targetVeh.position + vector3.worldup * targetVehOffsetH - rocket.position)
							if rocket.position.distanceto(targetVeh.position) > 20 then 
								rocket.applyforce(tmpDir * 4)
							else							
								'rocket.applyforce(tmpDir * 20)
								rocket.velocity = tmpDir * 80
							end if
							
							tmpPos = targetVeh.position
						elseif targetGround <> vector3.zero then
							tmpDir = vector3.normalize(targetGround - rocket.position)
							rocket.applyforce(tmpDir * 7)	

							tmpPos = targetGround
						end if
					end if
				else
					if exists(targetVeh) then						
						if rocket.position.z - rocket.position.toground.z < 2 then
							tmpDir = vector3.normalize(targetVeh.position + vector3.worldup * targetVehOffsetH + vector3.worldup * 2 - rocket.position)
						else
							tmpDir = vector3.normalize(targetVeh.position + vector3.worldup * targetVehOffsetH - rocket.position)
						end if
							
						if rocket.position.distanceto(targetVeh.position) > 7 then 
							rocket.applyforce(tmpDir * 7)
						else						
							'rocket.applyforce(tmpDir * 20)
							rocket.velocity = tmpDir * 80
						end if
						
						tmpPos = targetVeh.position
					elseif targetGround <> vector3.zero then
						tmpDir = vector3.normalize(targetGround - rocket.position)
						rocket.applyforce(tmpDir * 7)
						
						tmpPos = targetGround
					end if
					
					if timeWait <= 0 then						
						native.function.call("SET_OBJECT_RECORDS_COLLISIONS", rocket, true)
					else
						timeWait -= intervalFix
					end if
					
					camRocket.position = rocket.position - rocket.direction * 4.5 + vector3.worldup
					camRocket.lookat(rocket)
				end if
				
				if (FirstMove <= 0) orelse not bJavelin then
					'if not (bJavelin andalso (GoingUp <= 0) andalso (timeWait > 0)) then fixrotation = helper.DirectionToRotation(tmpDir, 0)
					dim tmpDiv as int16
					
					if rocket.position.distanceto(tmpPos) > 3 then
						tmpDiv = 10
					else
						tmpDiv = 50
					end if
					
					dim tmpRot as vector3 = helper.DirectionToRotation(tmpDir, 0)					
					dim incValue as double = math.abs(fixRotation.x - tmpRot.x) / tmpDiv
					
					if fixRotation.x > tmpRot.x then
						fixRotation.x -= incValue
					elseif fixRotation.x < tmpRot.x then
						fixRotation.x += incValue
					end if
					incValue = math.abs(fixRotation.Y - tmpRot.Y) / tmpDiv
					
					if fixRotation.Y > tmpRot.Y then
						fixRotation.Y -= incValue
					elseif fixRotation.Y < tmpRot.Y then
						fixRotation.Y += incValue
					end if
					
					if bJavelin then
						incValue = math.abs(fixRotation.z - tmpRot.z) / tmpDiv
						
						if fixRotation.z > tmpRot.z then
							fixRotation.z -= incValue
						elseif fixRotation.z < tmpRot.z then
							fixRotation.z += incValue
						end if
					else
						camRocket.rotation = tmpRot
					end if
				else
					fixrotation = helper.DirectionToRotation(fixDirection, 0)
				end if
				
				rocket.rotation = fixRotation
				
				if game.iskeypressed(hkRocketCam) andalso (not bJavelin orelse (FirstMove <= 0)) then					
					if camAim.isactive then camAim.deactivate
					
					if not camRocket.isactive then 
						camRocket.activate
						camRocket.lookat(rocket)
					end if
				else
					if camRocket.isactive then camRocket.deactivate
				end if
 			end if
		else
			rocket.visible = false
			
			if timeCheckRocket <= 0 then
				timeCheckRocket = 500
				
				if rocket.position.distanceto(player.character.position) > 2 then resetRocket
			else
				timeCheckRocket -= me.interval
			end if
		end if
		
		if not game.iskeypressed(hkAimKey) then
			if not bLaunched then
				vehList = nothing
				'cpTarget.visible = false
				timeLookingForVeh = 0
				timeLocked = 0
			end if
			
			if camAim.isactive then camAim.deactivate
			
			timeWaitAim = 50
			
			native.function.call("set_char_all_anims_speed", player.character, 1.0)
			
			switchFOV
			
			if bResetNV then
				bResetNV = false
				
				for each l as TNVLight in TNVLightVehList					
					for each li as lights in l.lightList
						li.l.disable
					next
				next
				for each l as TNVLight in TNVLightPedList
					l.l.disable
					l.l2.disable
				next
			end if
			
			bLocking = false
		elseif (player.character.weapons.current = weapon.Heavy_RocketLauncher) andalso not player.character.isragdoll andalso not player.character.isgettingup then			
			if bJavelin then
				if bNVOn andalso bJavelin then
					bResetNV = true
					
					if timeReloadNV <= 0 then					
						timeReloadNV = 500
						
						for each l as TNVLight in TNVLightVehList							
							for each li as lights in l.lightList
								li.l.disable
							next
						next
						for each l as TNVLight in TNVLightPedList
							l.l.disable
							l.l2.disable
						next
						
						TNVLightVehList.clear
						TNVLightPedList.clear
						
						if not vehList is nothing then
							for each v as vehicle in world.getvehicles(player.character.position + game.currentcamera.direction * (MaxAttackDistance / 2) * 2, MaxAttackDistance * 2)
								if exists(v) andalso (v.health > 0) andalso (v <> player.character.currentvehicle) then
									tmpTNVLight = new TNVLight									
									tmpTNVLight.v = v
									
									tmpLight = new lights
									tmpLight.offSet = vector3.relativeback * (v.model.getdimensions.y / 3)							
									tmpLight.l.range = (v.model.getdimensions.y * 0.85)								
									tmpTNVLight.lightList.add(tmpLight)
									
									if v.model.getdimensions.y > 5.9 then
										tmpLight = new lights
										tmpLight.offSet = vector3.relativeback * (v.model.getdimensions.y / 5)
										tmpLight.l.range = (v.model.getdimensions.y * 0.85)									
										tmpTNVLight.lightList.add(tmpLight)
										tmpLight = new lights
										tmpLight.offSet = vector3.relativefront * (v.model.getdimensions.y / 5)									
										tmpLight.l.range = (v.model.getdimensions.y * 0.85)
										tmpTNVLight.lightList.add(tmpLight)
									end if
									
									tmpLight = new lights
									tmpLight.offSet = vector3.relativefront * (v.model.getdimensions.y / 3)
									tmpLight.l.range = (v.model.getdimensions.y * 0.85)
									tmpTNVLight.lightList.add(tmpLight)
									
									if v.model.getdimensions.y < 5.9 then
										tmpTNVLight.VOff = (v.model.getdimensions.z) - ((v.position.z - v.position.toground.z) / 2)
										tmpTNVLight.bLarge = false
									else
										tmpTNVLight.bLarge = true
										tmpTNVLight.VOff = (v.model.getdimensions.z)
									end if
									
									TNVLightVehList.add(tmpTNVLight)
								end if
							next
							
							for each p as ped in world.getpeds(player.character.position + game.currentcamera.direction * (MaxAttackDistance / 2) * 2, MaxAttackDistance * 2)
								if exists(p) andalso (p.health > 0) andalso (p <> player.character) andalso not p.issittinginvehicle then
									tmpTNVLight = new TNVLight
									tmpTNVLight.l.color = color.green
									tmpTNVLight.l.range = 1
									tmpTNVLight.l.intensity = 1000
									tmpTNVLight.l2.color = color.green
									tmpTNVLight.l2.range = 1
									tmpTNVLight.l2.intensity = 1000
									tmpTNVLight.p = p
									tmpTNVLight.VOff = 0.3
									TNVLightPedList.add(tmpTNVLight)
								end if
							next
						end if
					else
						timeReloadNV -= me.interval
					end if
				else
					if TNVLightVehList.count > 0 then
						for each l as TNVLight in TNVLightVehList							
							for each li as lights in l.lightList
								li.l.disable
							next
						next
						
						TNVLightVehList.clear
					end if
					if TNVLightPedList.count > 0 then
						for each l as TNVLight in TNVLightPedList
							l.l.disable
							l.l2.disable
						next
						
						TNVLightPedList.clear
					end if
				end if
			end if
		
			if game.iskeypressed(hkZoomIN) orelse game.iskeypressed(hkZoomOUT) then
				if game.iskeypressed(hkZoomIN) then
					FOV -= 1
				elseif game.iskeypressed(hkZoomOUT) then
					FOV += 1
				end if
				
				if FOV > 50 then
					FOV = 50
				elseif FOV < minFOV then
					FOV = minFOV
				end if
				
				camAim.fov = FOV
			end if
			
			if not exists(myRpgObj) then
				for each o as gta.object in world.getallobjects("rpg")
					if exists(o) andalso o.isAttachedSomewhere andalso (o.position.distanceto(player.character.position) < 2) then
						myRpgObj = o
						exit for
					end if
				next
			end if
				
			if exists(myRpgObj) andalso not camRocket.isactive then				
				'camAim.position = myRpgObj.getoffsetposition(vector3.relativefront)
				camAim.position = player.character.position + player.character.direction + vector3.worldup * 0.6
				dim tmpRot as vector3 = camAim.rotation
				tmpRot.x = myRpgObj.rotation.y * -1
				tmpRot.z = myRpgObj.rotation.z - 90
				camAim.rotation = tmpRot
				
				if timeWaitAim <= 0 then
					if game.iskeypressed(hkSteadyAim) then
						native.function.call("set_char_all_anims_speed", player.character, 0.01)
					else
						native.function.call("set_char_all_anims_speed", player.character, 0.1)
					end if
					
					if not camAim.isactive then camAim.activate
				else
					timeWaitAim -= intervalFix
				end if
			end if
			
			if bNVOn andalso bJavelin andalso camAim.isactive then
				'if timeNVTick <= 0 then
				'	timeNVTick = 20
					
					for each l as TNVLight in TNVLightVehList
						if exists(l.v) andalso (l.v.health > 0) andalso l.v.isonscreen then
							dim tmpLightPos as vector3
							
							for each li as lights in l.lightList
								tmpLightPos = l.v.GetOffsetPosition(li.offSet) + vector3.worldup * l.VOff * 1.5 - game.currentcamera.direction * (l.VOff / 2)
								if tmpLightPos.z - tmpLightPos.toground.z < 3 then tmpLightPos.z = tmpLightPos.toground.z + 3
								li.l.position = tmpLightPos
								li.l.enabled = true
							next
						else
							for each li as lights in l.lightList
								li.l.enabled = false
							next
						end if
					next
				
					for each l as TNVLight in TNVLightPedList
						if exists(l.p) andalso (l.p.health > 0) andalso l.p.isonscreen then
							l.l.position = l.p.getboneposition(bone.head) - game.currentcamera.direction * l.VOff
							l.l.enabled = true
							l.l2.position = l.p.getboneposition(bone.root) - game.currentcamera.direction * l.VOff
							l.l2.enabled = true
						else
							l.l.enabled = false
							l.l2.enabled = false
						end if
					next
				'else
				'	timeNVTick -= me.interval
				'end if
			end if
			
			if not bLaunched then
				if vehList is nothing then
					vehList = world.getvehicles(player.character.getboneposition(bone.head) + game.currentcamera.direction * (MaxAttackDistance / 2), MaxAttackDistance)
				end if
				
				if exists(vehList) andalso (bLocking orelse bAutoLocking) then
					if exists(tmpTargetVeh) andalso _
					   tmpTargetVeh.position.distanceto(player.character.position + game.currentcamera.direction * tmpTargetVeh.position.distanceto(player.character.position)) > 4 then
						targetVeh = nothing
						tmpTargetVeh = nothing
						timeLocked = 0
						timeLookingForVeh = 0
					end if
					
					dim tmpGroundPos as vector3 = getGroundPos(MaxAttackDistance)
					
					if not exists(tmpTargetVeh) then
						for each v as vehicle in vehList
							if exists(v) then
								if (v.position.distanceto(player.character.position) > 10) andalso _
								   (v.position.distanceto(player.character.position) < tmpGroundPos.distanceto(player.character.position)) andalso _
								   (v.position.distanceto(player.character.position + game.currentcamera.direction * v.position.distanceto(player.character.position)) < 2) then									
									tmpTargetVeh = v
									targetGround = vector3.zero
									tmpTargetGround = vector3.zero
									timeLocked = 0
									targetVehOffsetH = v.model.getdimensions.z / 4
									exit for
								end if
							end if
						next
					end if
					
					if exists(tmpTargetVeh) then					
						timeLookingForVeh = 0
						
						if timeLocked > 300 then
							targetVeh = tmpTargetVeh
							
							if soundLocked = "" then
								native.function.call("stop_sound", BeepSID)
								native.function.call("PLAY_SOUND_FROM_ped", BeepSID, "GENERAL_FRONTEND_GAME_ELECTRIC_ALARM", player.character)
							else
								sndLocked.stop
								sndLocked.play
							end if
							'cpTarget.position = tmpTargetVeh.position + vector3.worldup * (tmpTargetVeh.model.getdimensions.z / 2)
							'cpTarget.diameter = tmpTargetVeh.position.distanceto(player.character.position) / 100
							'cpTarget.visible = true
						else
							timeLocked += intervalFix
							'cpTarget.visible = false
							
							if (soundLocking <> "") andalso (camAim.isactive) then
								if timeLockingBeep <= 0 then
									timeLockingBeep = 50
									sndLocking.play
								else
									timeLockingBeep -= intervalFix
								end if
							end if
						end if
					else
						targetVeh = nothing
						'cpTarget.visible = false
						
						if timeLookingForVeh > 300 then
							if tmpGroundPos <> vector3.zero then
								if (tmpTargetGround <> vector3.zero) andalso (tmpTargetGround.distanceto(tmpGroundPos) > 5) then
									tmpTargetGround = vector3.zero
									targetGround = vector3.zero
								elseif tmpGroundPos.distanceto(player.character.position) < 220 then
									if tmpTargetGround = vector3.zero then tmpTargetGround = tmpGroundPos
									
									if timeLocked > 300 then
										targetGround = tmpTargetGround
										
										if soundLocked = "" then
											native.function.call("stop_sound", BeepSID)
											native.function.call("PLAY_SOUND_FROM_ped", BeepSID, "GENERAL_FRONTEND_GAME_ELECTRIC_ALARM", player.character)
										else
											sndLocked.stop
											sndLocked.play
										end if
										'cpTarget.position = targetGround
										'cpTarget.diameter = targetGround.distanceto(player.character.position) / 100
										'cpTarget.visible = true
									else
										timeLocked += intervalFix
										'cpTarget.visible = false
										
										if (soundLocking <> "") andalso (camAim.isactive) then
											if timeLockingBeep <= 0 then
												timeLockingBeep = 100
												sndLocking.play
											else
												timeLockingBeep -= intervalFix
											end if
										end if
									end if
								end if
							else
								timeLocked = 0
							end if
						else
							timeLookingForVeh += intervalFix
							timeLocked = 0
							'cpTarget.visible = false
						end if
					end if
				end if		
			end if
		end if
		
		for each t as TFakeTrain in TFakeTrainList
			if t.bSet then
				if not exists(t.trainObj) then t.trainObj = world.createobject(fakeTrainModel, t.pos)
				
				if exists(t.trainObj) then					
					t.bSet = false
					t.bMove = true
					t.trainObj.rotation = t.rot
					
					native.function.call("SET_OBJECT_INITIAL_VELOCITY",	t.trainObj, t.trainObj.direction.x * t.speed, t.trainObj.direction.y * t.speed, 0.5)
					
					world.addexplosion(t.trainObj.position, explosiontype.rocket, 1.0)
				end if
			end if
		next
	end sub
	
	private function startSlowMoFX
		game.timescale = 0.1
		
		dim tmpPos as vector3
		dim tmpPosLook as vector3
		
		if exists(targetVeh) then
			tmpPos = rocket.position
			
			tmpPosLook = tmpPos
			
			tmpPos -= fixDirectionAux * targetVeh.model.getdimensions.y * 1.1
		else
			tmpPos = targetGround
			tmpPosLook = tmpPos
			
			tmpPos -= fixDirectionAux * 6
		end if
		
		tmpPos.z = tmpPosLook.z
		tmpPos += vector3.worldup * 2
		
		camRocket.position = tmpPos
		camRocket.activate
	end function
	
	private sub switchFOV
		if bJavelin then
			if zoomType <= 1 then
				FOV = WFOV
			else
				FOV = NFOV
			end if
			
			bNVOn = zoomType <> 0
		else
			FOV = 50
		end if
		
		camAim.fov = FOV
	end sub
	
	private function getGroundPos(maxDist as double)
		dim vecIni as vector3 = player.character.getboneposition(bone.head) + game.currentcamera.direction * 10
		dim vecRes as vector3
		
		while vecIni.distanceto(player.character.position) < maxDist
			vecIni += game.currentcamera.direction * 0.5
			
			vecRes = world.getgroundposition(vecIni, groundtype.highest)
			
			if vecRes.distanceto(vecIni) < 1 then return vecRes
		end while
		
		return vector3.zero
	end function
	
	' draw the textures adapting the position, width and height to the user resolution
	private sub drawSpriteAux(byval e As GTA.GraphicsEventArgs, tex as texture, x as double, y as double, w as double, h as double, _
	   rot as double, col as color, optional square as boolean = false)
		if square then
			e.graphics.drawsprite(tex, x * width_Coef, y * height_Coef, w * width_Coef, h * width_Coef, rot, col)
		else
			e.graphics.drawsprite(tex, x * width_Coef, y * height_Coef, w * width_Coef, h * height_Coef, rot, col)
		end if
	end sub
	
	private sub drawLineAux(byval e As GTA.GraphicsEventArgs, xIni as double, yIni as double, xFin as double, yFin as double, _
	   w as double, col as color)
		e.graphics.drawline(xIni * width_Coef, yIni * height_Coef, xFin * width_Coef, yFin * height_Coef, w * width_Coef, col)
	end sub
	
	private sub drawTextAux(byval e As GTA.GraphicsEventArgs, text as string, x as double, y as double, col as color)
		e.graphics.drawtext(text, x * width_Coef, y * height_Coef, col)
	end sub
	
	private sub drawFrameAux(byval e As GTA.GraphicsEventArgs, x as double, y as double, w as double, h as double, lw as double, col as color)
		drawLineAux(e, x - (w / 2), y - (h / 2), x + (w / 2), y - (h / 2), 2, color.fromargb(150, 255, 255, 255))
		drawLineAux(e, x - (w / 2), y + (h / 2), x + (w / 2), y + (h / 2), 2, color.fromargb(150, 255, 255, 255))
		drawLineAux(e, x - (w / 2), y - (h / 2), x - (w / 2), y + (h / 2), 2, color.fromargb(150, 255, 255, 255))
		drawLineAux(e, x + (w / 2), y - (h / 2), x + (w / 2), y + (h / 2), 2, color.fromargb(150, 255, 255, 255))
	end sub
	
	Private Sub GraphicsEventHandler(ByVal sender As Object, ByVal e As GTA.GraphicsEventArgs) Handles mybase.PerFrameDrawing
		if bNormalMode then exit sub
		
		if game.iskeypressed(hkAimKey) andalso camAim.isactive andalso player.character.isalive then
			if exists(tmpTargetVeh) orelse exists(targetVeh) orelse (targetGround <> vector3.zero) orelse (tmpTargetGround <> vector3.zero) then
				dim pos as vector3
				dim tmpColor as color
				
				if timeLocked >= 300 then
					if bJavelin andalso bNVOn then
						tmpColor = color.fromargb(150, 0, 255, 0)
					else						
						tmpColor = color.fromargb(100, 255, 0, 0)
					end if
				else
					tmpColor = color.fromargb(100, 255, 255, 255)
				end if
				
				if exists(targetVeh) then
					pos = targetVeh.position					
				elseif exists(tmpTargetVeh) then
					pos = tmpTargetVeh.position					
				elseif targetGround <> vector3.zero then
					pos = targetGround
				else
					pos = tmpTargetGround
				end if
				
				dim float_temp_1 as double
				dim TO_RADIAN = 0.017453292519943295
				float_temp_1 = Math.Atan2((pos.Y - Player.Character.Position.Y) , (pos.X - Player.Character.Position.X))
				float_temp_1 = float_temp_1 - Game.CurrentCamera.Rotation.Z * TO_RADIAN
				float_temp_1 += 1.570796
				float_temp_1 = (0.51 + 0.9f * (Math.Sin(float_temp_1))) * myWidth
				
				dim cam as camera = game.currentcamera
				dim dist as double = pos.distanceto(camAim.position)
				dim compPos as vector3 = (camAim.position + camAim.direction * dist)
				dim y as double = (((((compPos - pos).z)) / dist) + 0.47) * myHeight
				
				if bJavelin then
					drawLineAux(e, 0, y, 1680, y, 2, tmpColor)
					drawLineAux(e, float_temp_1, 0, float_temp_1, 1050, 2, tmpColor)
				else
					drawLineAux(e, float_temp_1 - 40, y, float_temp_1 + 40, y, 2, tmpColor)
					drawLineAux(e, float_temp_1, y - 40, float_temp_1, y + 40, 2, tmpColor)
				end if
			end if
			
			if bJavelin then
				if timeLocked < 300 then drawFrameAux(e, 840, 525, 190, 125, 2, color.fromargb(150, 255, 255, 255))
			else
				drawLineAux(e, 820, 525, 860, 525, 2, color.fromargb(150, 255, 255, 255))
				drawLineAux(e, 840, 510, 840, 540, 2, color.fromargb(150, 255, 255, 255))
			end if
			
			if bJavelin then
				if bNVOn then drawLineAux(e, 100, 525, 1400, 525, 800, color.fromargb(80, 0, 255, 0))
				
				drawSpriteAux(e, texHUD, 840, 525, 1393, 970, 0, color.white)
				drawLineAux(e, 0, 15, 1680, 15, 130, color.fromargb(255, 9, 15, 15))
				drawLineAux(e, 0, 1050, 1680, 1050, 145, color.fromargb(255, 9, 15, 15))
				drawLineAux(e, 85, 0, 85, 1050, 190, color.fromargb(255, 9, 15, 15))
				drawLineAux(e, 1590, 0, 1590, 1050, 180, color.fromargb(255, 9, 15, 15))
				
				if bNVOn then drawSpriteAux(e, texNV, 263, 313, 150, 149, 0, color.white)
				
				if (timeLocked > 0) andalso (timeLocked < 290) orelse ((timeLookingForVeh > 290) andalso (timeLocked < 290)) then drawSpriteAux(e, texCLU, 263, 525, 250, 250, 0, color.white)			
				
				if not bLaunched then 
					drawSpriteAux(e, texRReady, 970, 900, 147, 147, 0, color.white)
				else
					drawSpriteAux(e, texLaunched, 1252, 900, 147, 147, 0, color.white)
				end if
				
				if bLocking orelse (bAutoLocking andalso (timeLocked >= 300)) then drawSpriteAux(e, texLock, 1252, 150, 148, 148, 0, color.white)
				'if (timeLocked >= 300) andalso exists(targetVeh) then drawSpriteAux(e, texDir, 1420, 523, 149, 149, 0, color.white)
				'if (timeLocked >= 300) andalso (targetGround <> vector3.zero) then drawSpriteAux(e, texTop, 1420, 313, 147, 149, 0, color.white)
				if bAttackDir then 
					drawSpriteAux(e, texDir, 1420, 523, 149, 149, 0, color.white)
				else
					drawSpriteAux(e, texTop, 1420, 313, 147, 149, 0, color.white)
				end if
				
				if zoomType = 2 then
					drawSpriteAux(e, texNFOV, 980, 150, 149, 149, 0, color.white)
				elseif zoomType = 1
					drawSpriteAux(e, texWFOV, 718, 150, 150, 149, 0, color.white)
				else
					drawSpriteAux(e, texDAY, 426, 150, 150, 149, 0, color.white)
				end if
			else
				drawLineAux(e, 210, 210, 1470, 210, 4, color.fromargb(100, 255, 255, 255))
				drawLineAux(e, 210, 840, 1470, 840, 4, color.fromargb(100, 255, 255, 255))
			end if
		end if
	end sub
	
	private function rotateVec(vec as vector3, angle as double)
		angle = angle * (3.1415 / 180)
		
		dim s as double = system.math.sin(angle)
		dim c as double = system.math.cos(angle)
		
		vec.x = vec.x * c - vec.y * s
		vec.y = vec.x * s + vec.y * c
		
		return vec
	end function

	private sub console_CMD(ByVal sender As Object, ByVal e As ConsoleEventArgs) Handles MyBase.ConsoleCommand
		If e.Command = "tjavelin" Then
			bJavelin = true
			bNormalMode = false
			game.console.print("Javelin mode...")
		end if
		
		If e.Command = "tstinger" Then 
			bJavelin = false
			bNormalMode = false
			game.console.print("Stinger mode...")
		end if
		
		If e.Command = "tnormal" Then 
			bJavelin = false
			bNormalMode = true
			game.console.print("Normal mode...")
		end if
		
		If e.Command = "tammo" Then
			player.character.weapons.RocketLauncher.ammo += 10
			game.console.print("An gift for you...")
		end if
		
		if bJavelin then
			Power = JavelinPower
		else
			Power = StingerPower
		end if
	end sub
	
	private function intervalFix
		return me.interval * (game.fps / 20)
	end function
	
	private sub resetRocket
		native.function.call("stop_ptfx", PTFXSmoke)		
		native.function.call("stop_sound", MoveSID)
		rocket.visible = false
		
		wait(250)
		
		native.function.call("SET_OBJECT_RECORDS_COLLISIONS", rocket, false)
		native.function.call("ATTACH_OBJECT_TO_PED", rocket, player.character, bone.righthand, 0, 0, 0, 0, 0, 0)

		targetGround = vector3.zero
		tmpTargetGround = vector3.zero
		vehList = nothing
		targetVeh = nothing
		tmpTargetVeh = nothing
		'cpTarget.visible = false
		if camRocket.isactive then camRocket.deactivate
	end sub
End Class